module net.BurtonRadons.spyl.valueFunction;

private import net.BurtonRadons.spyl.value;

class FunctionValue : Value
{
    union
    {
        Value delegate (Value []) a;
        void delegate (Value []) b;
        Value delegate () c;
        Value delegate (Value) d;
    }
    
    Value delegate (Value []) func; /**< Function to actually call. */
    char [] docString; /**< Description std.string. */
    
    this (Value delegate (Value []) a, char [] doc) { this.a = a; this.func = a; this.docString = doc; }
    this (void delegate (Value []) b, char [] doc) { this.b = b; this.func = &callB; this.docString = doc; }
    this (Value delegate () c, char [] doc) { this.c = c; this.func = &callC; this.docString = doc; }
    this (Value delegate (Value) d, char [] doc) { this.d = d; this.func = &callD; this.docString = doc; }
    
    Value callA (Value [] args) { return a (args); }
    Value callB (Value [] args) { b (args); return Null; }
    Value callC (Value [] args) { return c (); }
    Value callD (Value [] args) { assert (args.length == 1); return d (args [0]); }
    
    override char [] typeName ()
    {
        return "Function";
    }
    
    override char [] repr ()
    {
        return "<<Function>>";
    }
    
    override Value call (Value [] args)
    {
        return func (args);
    }
    
    override char [] doc ()
    {
        return docString;
    }
}

class AttributeFunctionValue : FunctionValue
{
    this (Value delegate () a, char [] desc) { super (a, desc); }
    
    override char [] typeName ()
    {
        return "AttributeFunction";
    }
    
    override Value expand ()
    {
        return call (null);
    }
}

